//
//  Chap6.h
//  Sinc
//
//  Created by 杉浦 洋 on 2018/04/01.
//  Copyright © 2018年 杉浦 洋. All rights reserved.
//

#ifndef Chap6_h
#define Chap6_h
/*-----------------------------------------------------*/
/*［６］Dunnett分布                                      */
/*-----------------------------------------------------*/
/*漸近分布関数*/
double B1CDF(double t,int k,double* lms){ /*両側Dunnet漸近分布関数B_1(t|k,λ）*/
    /* lms[k]={λ_1,λ_2,...,λ_k}*/
    double R,h,xi,S,slm,termi;
    double a[30],b[30];
    int ne,n,i,j;
    if(!(2<=k && k<=20)) return NAN;
    if(t < 0) return 0;
    ne = 11;/*倍精度標準標本点数*/
    R = 8.3;/*半区間*/
    slm=0;
    for(i=0;i<k;i++) slm+=lms[i];
    n=ne*ceil(sqrt(slm/lms[0]));/*台半幅分割数*/
    h = R/n;/*標本点間隔*/
    for(i=2;i<=k;i++){ /*係数*/
        a[i]=sqrt(lms[i-1]/lms[0]);
        b[i]=sqrt(1+lms[i-1]/lms[0]);
    };
    //積分
    S=0;
    for(i=-n;i<=n;i++){
        xi = i*h; /*標本点x_i*/
        termi = phiPDF(1,xi);
        for(j=2;j<=k;j++){
            termi*=PhiCDF(1,a[j]*xi+b[j]*t) - PhiCDF(1,a[j]*xi-b[j]*t);
        };
        S+= termi; /*第i項を加算*/
    };
    return h*S;
};
double B2CDF(double t,int k,double* lms){ /*片側Dunnet漸近分布関数B_2(t|k,λ）*/
    /* lms[k]={λ_1,λ_2,...,λ_k}*/
    double R,h,xi,S,slm,termi;
    double a[30],b[30];
    int ne,n,i,j;
    if(!(2<=k && k<=20)) return NAN;
    if(t < 0) return 0;
    ne = 11;/*倍精度標準標本点数*/
    R = 8.3;/*半区間*/
    slm=0;
    for(i=0;i<k;i++) slm+=lms[i];
    n=ne*ceil(sqrt(slm/lms[0]));/*台半幅分割数*/
    h = R/n;/*標本点間隔*/
    for(i=2;i<=k;i++){ /*係数*/
        a[i]=sqrt(lms[i-1]/lms[0]);
        b[i]=sqrt(1+lms[i-1]/lms[0]);
    };
    //積分
    S=0;
    for(i=-n;i<=n;i++){
        xi = i*h; /*標本点x_i*/
        termi = phiPDF(1,xi);
        for(j=2;j<=k;j++){
            termi*=PhiCDF(1,a[j]*xi+b[j]*t);
        };
        S+= termi; /*第i項を加算*/
    };
    return h*S;
};

//分布関数
double TB1CDF(double t,int k,int* ns){ /*両側Dunnett分布関数TB_1(t|k,ns)*/
    /* ns[k]={n_1,n_2,...,n_k}*/
    int m,i;
    double lms[25];
    if(!(2<=k && k<=20)) {return NAN;};
    if(t < 0) {return 0;};
    for(i=0;i<k;i++) lms[i]=(double)ns[i];
    m=-k;
    for(i=0;i<k;i++) m+=ns[i];/*m = n-k*/
    return chiIntegralDunnett(B1CDF,t,k,lms,m);
};
double TB2CDF(double t,int k,int* ns){ /*片側Dunnett分布関数TB_1(t|k,ns)*/
    /* ns[k]={n_1,n_2,...,n_k}*/
    int m,i;
    double lms[25];
    if(!(2<=k && k<=20)) {return NAN;};
    if(t < 0) {return 0;};
    for(i=0;i<k;i++) lms[i]=(double)ns[i];
    m=-k;
    for(i=0;i<k;i++) m+=ns[i];/*m = n-k*/
    return chiIntegralDunnett(B2CDF,t,k,lms,m);
};
double TB1mCDF(double t,int l,double* lms,int m){ /*両側Dunnett分布関数TB_1(t|l,lms,m)*/
    /* ns[k]={n_1,n_2,...,n_k}*/
    if(!(2<=l && l<=20)) {return NAN;};
    if(t < 0) {return 0;};
    if(m==-1) return B1CDF(t,l,lms);/*漸近分布漸近分布*/
    return chiIntegralDunnett(B1CDF,t,l,lms,m);
};
double TB2mCDF(double t,int l,double* lms,int m){ /*両側Dunnett分布関数TB_1(t|l,lms,m)*/
    /* ns[k]={n_1,n_2,...,n_k}*/
    if(!(2<=l && l<=20)) {return NAN;};
    if(t < 0) {return 0;};
    if(m==-1) return B2CDF(t,l,lms);/*漸近分布漸近分布*/
    return chiIntegralDunnett(B2CDF,t,l,lms,m);
};
/*100α%点*/
double b1Fun(int k,double *lms,double al){/*B_1^-1(1-al|k,m)*/
    if(!(2<=k && k<=20)||!(1.0e-8<=al && al<=0.5)) return NAN;
    return SecantDunnettB(B1CDF,k,lms,al);
};
double b2Fun(int k,double *lms,double al){/*B_2^-1(1-al|k,m)*/
    if(!(2<=k && k<=20)||!(1.0e-8<=al && al<=0.5)) return NAN;
    return SecantDunnettB(B2CDF,k,lms,al);
};
double tb1Fun(int k,int *ns,double al){/*TB_1^-1(1-al|k,m)*/
    if(!(2<=k && k<=20)||!(1.0e-8<=al && al<=0.5)) return NAN;
    return SecantDunnettTB(TB1CDF,k,ns,al);
};
double tb2Fun(int k,int *ns,double al){/*TB_2^-1(1-al|k,m)*/
    if(!(2<=k && k<=20)||!(1.0e-8<=al && al<=0.5)) return NAN;
    return SecantDunnettTB(TB2CDF,k,ns,al);
};
double tb1mFun(int l,double* lms,int m,double al){/*TB_1^-1(1-al|k,m)*/
    if(!(2<=l && l<=20)||!(1.0e-8<=al && al<=0.5)) return NAN;
    return SecantNormalB(TB1mCDF,l,lms,m,al);
};
double tb2mFun(int l,double* lms,int m,double al){/*TB_1^-1(1-al|k,m)*/
    if(!(2<=l && l<=20)||!(1.0e-8<=al && al<=0.5)) return NAN;
    return SecantNormalB(TB2mCDF,l,lms,m,al);
};

/*表関数(T3型)*/
double* tb1Tab(int k,int n1,int n2,double al){/*tb1FunのT3型表配列*/
    int i,m;
    double lms[25];
    /*lms={n1,n2,...,n2}の設定*/
    lms[0] = n1;
    for(i=1;i<k;i++){
        lms[i] = n2;
    };
    m = n1+(k-1)*n2-k;
    return MakeTabT2DunnettT(tb1mFun,k,lms,m,al);
};
double* tb2Tab(int k,int n1,int n2,double al){/*tb2FunのT3型表配列*/
    int i,m;
    double lms[25];
    /*lms={n1,n2,...,n2}の設定*/
    lms[0] = n1;
    for(i=1;i<k;i++){
        lms[i] = n2;
    };
    m = n1+(k-1)*n2-k;
    return MakeTabT2DunnettT(tb2mFun,k,lms,m,al);
};
double* b1Tab(int k,int n1,int n2,double al){/*b1FunのT3型表配列*/
    int i;
    double lms[25];
    /*ns={n1,n2,...,n2}の設定*/
    lms[0]=n1;
    for(i=1;i<k;i++) lms[i]=n2;
    return MakeTabT2Dunnett(b1Fun,k,lms,al);
};
double* b2Tab(int k,int n1,int n2,double al){/*b2FunのT3型表配列*/
    int i;
    double lms[25];
    /*ns={n1,n2,...,n2}の設定*/
    lms[0]=n1;
    for(i=1;i<k;i++) lms[i]=n2;
    return MakeTabT2Dunnett(b2Fun,k,lms,al);
};
#endif /* Chap6_h */
